/*
 * <nagg01.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library g01 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2155 (Feb 1998).
 * Mark 6 revised. IER-3040 (July 2000).
 * Mark 7 revised. IER-3903 (Feb 2001):
 *       "class" replaced by "class_ind" in the g01aec header,
 *       otherwise nagg01.h does not compile when used from C++.
 *
 */
#ifndef NAGG01
#define NAGG01

/// ML 9/22/2004 COMPILING_ONAG8HEADERS_IN_OC
#ifndef _MSC_VER	   //VC
	// This must be put into every header since it does not appear to be
	// inheritable from parent header to child (#include-ded) header:
	#pragma dll(ONAG8)
#endif // !_MSC_VER	   //VC
/// end COMPILING_ONAG8HEADERS_IN_OC

#ifdef __cplusplus
extern "C"
{
#endif
  /* begin proto */
  extern NAG_DLL_EXPIMP
   void NAG_CALL g01aac(Integer n, double x[], double wt[], Integer *nvalid,
                                             double *xmean, double *xsd, double *xskew, double *xkurt,
                                             double *xmin, double *xmax, double *wsum, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g01adc(Integer k, const double x[], const Integer ifreq[], double *xmean, double *xsd, double *xskew, double *xkurt, Integer *n, NagError *fail);

  extern NAG_DLL_EXPIMP
   void NAG_CALL g01aec(Integer n, const double x[], Integer num_class, Nag_ClassBoundary class_ind,
                     double cint[], Integer ifreq[], double *xmin, double *xmax,
                     NagError *fail);
  extern void g01aef_f(Integer n, Integer k2, const double x[], Integer iclass,
                       double cint[], Integer ifreq[], double *xmin, double *xmax,
                       Integer *ifail);
  extern void g01aff_f(Integer inob, Integer ipred, Integer m, Integer n,
                       Integer nobs[], Integer *num, double pred[], double *chis,
                       double p[], Integer *npos, Integer *ndf, Integer *m1,
                       Integer *n1, Integer *ifail);
  extern void g01agf_f(const double x[], double y[], Integer nobs, Integer isort[],
                       Integer nstepx, Integer nstepy, Integer *ifail);
  extern void g01agy_f(const double x[], const double y[], double *xmin, double xstep,
                       Integer *nstepx, double *ymin, double ystep, Integer *nstepy,
                       Integer nobs, Integer maxa, Integer maxb, const Integer key[],
                       Integer maxya, Integer maxyb);
  extern void g01agz_f(double zmn, double zmx, Integer nstep, double *znmin,
                       double *step, Integer *maxa, Integer *maxb);
  extern NAG_DLL_EXPIMP void NAG_CALL g01alc(Integer n,  double x[], double res[],  NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL g01bcc(double x, Integer n, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g01bjc(Integer n,  double p,  Integer k,  double *plek,
                                             double *pgtk, double *peqk, NagError *fail);
  extern void g01bjf_f(Integer n, double p, Integer k, double *plek,
                       double *pgtk, double *peqk, Integer *ifail);
  extern double g01bju_f(double x);
  extern double g01bju(double x, Integer *local_error);
  extern double g01bjv_f(double x);
  extern double g01bjv(double x, Integer *local_error);
  extern void g01bjw_f(double x, double a, double b, double *lpabx);
  extern void g01bjw(double x, double a, double b, double *lpabx,
                     Integer *local_error);
  extern void g01bjx_f(double x, double a, double b, double *jabx);
  extern void g01bjx(double x, double a, double b, double *jabx);
  extern void g01bjy_f(double x, double a, double b, double *iabx);
  extern void g01bjy(double x, double a, double b, double *iabx);
  extern void g01bjz_f(double x, double a, double b, double *pltx,
                       double *pgtx, double *pabx);
  extern void g01bjz(double x, double a, double b, double *pltx,
                     double *pgtx, double *pabx, Integer *local_error);
  extern NAG_DLL_EXPIMP void NAG_CALL g01bkc(double rlamda,  Integer k,  double *plek,
                                             double *pgtk, double *peqk,  NagError *fail);
  extern void g01bkf_f(double rlamda, Integer k, double *plek, double *pgtk,
                       double *peqk, Integer *ifail);
  extern void g01bkw_f(double x, double a, double *lpax);
  extern void g01bkw(double x, double a, double *lpax, Integer *local_error);
  extern void g01bkx_f(double x, double a, double *jax);
  extern void g01bkx(double x, double a, double *jax);
  extern void g01bky_f(double x, double a, double *iax);
  extern void g01bky(double x, double a, double *iax);
  extern void g01bkz_f(double x, double a, double *pltx, double *pgtx,
                       double *pax);
  extern void g01bkz(double x, double a, double *pltx, double *pgtx,
                     double *pax, Integer *local_error);
  extern NAG_DLL_EXPIMP void NAG_CALL g01blc(Integer n, Integer l, Integer m, Integer k,  double *plek,
                                             double *pgtk, double *peqk,  NagError *fail);
  extern void g01blw(Integer k, Integer n, Integer l, Integer m,  double *lpk,
                     Integer *local_error);
  extern void g01blx(Integer k, Integer n, Integer l, Integer m,  double *jk);
  extern void g01bly(Integer k, Integer n, Integer l, Integer m,  double *ik);
  extern void g01blz(Integer k, Integer n, Integer l, Integer m,  double *plek,
                     double *pgtk, double *pk, Integer *local_error);
  extern NAG_DLL_EXPIMP double NAG_CALL g01cec(double p, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g01dac(Integer n, double pp[], double etol, double *errest, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g01dac_0(Integer n,  double pp[], double etol, double *errest,
                     NagError *fail);
  extern void g01dax(Integer i, Integer n,  double crln, double rinc,
                     double *score, double *err);
  extern double g01day(Integer is, Integer n, Integer *ierror);
  extern void g01daz(Integer n, Integer ndiv2,  double crln[], double prob1[],
                     double pbest[], double pp[], double etol,
                     double *errest,  Integer *ifail);
  extern void g01dbc(Integer n,  double pp[],  NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g01dcc(Integer n, double exp1, double exp2, double sumssq, double vec[], NagError *fail);

  extern double g01dbz(Integer i, Integer n);
  extern NAG_DLL_EXPIMP void NAG_CALL g01ddc(Integer n,  double x[],  Boolean calc_wts,  double a[],
                                             double *w, double *pw,  NagError *fail);
  extern void g01ddy(Integer n,  double a[], double *eps, Integer *local_error);
  extern double g01ddz(double *c,  Integer n,  double x);
  extern NAG_DLL_EXPIMP void NAG_CALL g01dhc(Nag_Scores scores, Nag_Ties ties,  Integer n,  double x[],
                                             double r[], NagError *fail);
  extern double g01dht(char *scores,  Integer i, Integer n, Integer *local_error);
  extern void g01dhu(char *ties, char *scores,  Integer n,  double x[],
                     double r[],  Integer iwrk[], Integer *local_error);
  extern void g01dhv(Integer n,  double x[], double r[],  Integer iwrk[]);
  extern void g01dhw(char *ties,  Integer n,  double x[], double r[],
                     Integer iwrk[]);
  extern void g01dhx(Integer n,  double x[],  Integer iwrk[], Integer *local_error);
  extern void g01dhy(Integer n,  double x[], double r[],  Integer iwrk[]);
  extern void g01dhz(char *scores,  Integer n,  double r[], Integer *local_error);
  extern NAG_DLL_EXPIMP double NAG_CALL g01eac(Nag_TailProbability tail,  double x,  NagError *fail);
  extern double g01eaf_f(const char *tail, double x, Integer *ifail, Integer tail_len);
  extern NAG_DLL_EXPIMP double NAG_CALL g01ebc(Nag_TailProbability tail, double t, double df, NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL g01ebf_f(const char *tail, double t, double df, Integer *ifail,
                         Integer tail_len);
  extern NAG_DLL_EXPIMP double NAG_CALL g01ecc(Nag_TailProbability tail, double x, double df, NagError *fail);
  extern double g01ecf_f(const char *tail, double x, double df, Integer *ifail,
                         Integer tail_len);
  extern NAG_DLL_EXPIMP double NAG_CALL g01edc(Nag_TailProbability tail, double f, double df1, double df2,
                                               NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL g01edf_f(const char *tail, double f, double df1, double df2,
                         Integer *ifail, Integer tail_len);
  extern NAG_DLL_EXPIMP void NAG_CALL g01eec(double x, double a, double b, double tol, double *p,
                                             double *q, double *pdf, NagError *fail);
  extern void g01eef_f(double x, double a, double b, double tol,
                       double *p, double *q, double *pdf, Integer *ifail);
  extern NAG_DLL_EXPIMP double NAG_CALL g01efc(Nag_TailProbability tail, double g, double a, double b,
                                               NagError *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL g01emc(double q, double v, Integer ir, NagError *fail);

  extern double g01emf_f(double q, double v, Integer ir, Integer *ifail);
  extern NAG_DLL_EXPIMP double NAG_CALL g01emf_c(double q, double v, Integer ir, Integer *ifail);
  extern double g01emw_f(double y);
  extern double g01emw_c(double y, Nag_User *comm);
  extern double g01emx_f(double y);
  extern double g01emx_c(double y, Nag_User *comm);
  extern double g01emy_f(double x, double y);
  extern double g01emy_c(double x, double y, Nag_User *comm);
  extern double g01emz_f(double x);
  extern double g01emz_c(double x, Nag_User *comm);
  extern NAG_DLL_EXPIMP double NAG_CALL g01fac(Nag_TailProbability tail,  double p,  NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g01epc(Integer n, Integer ip, double d, double *pdl, double *pdu, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01erc(double t, double vk, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01etc(double x);

  extern NAG_DLL_EXPIMP double NAG_CALL g01euc(double x, const double comm_arr[]);

  extern NAG_DLL_EXPIMP double NAG_CALL g01eyc(Integer n, double d, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01ezc(Integer n1, Integer n2, double d, NagError *fail);

  extern double g01faz_f(double p, Integer *ifail);
  extern NAG_DLL_EXPIMP double NAG_CALL g01fbc(Nag_TailProbability tail, double p, double df, NagError *fail);
  extern double g01fbf_f(const char *tail, double p, double df, Integer *ifail,
                         Integer tail_len);
  extern NAG_DLL_EXPIMP double NAG_CALL g01fcc(double p, double df, NagError *fail);
  extern double g01fcf_f(double p, double df, Integer *ifail);
  extern NAG_DLL_EXPIMP double NAG_CALL g01fdc(double p, double df1, double df2, NagError *fail);
  extern double g01fdf_f(double p, double df1, double df2, Integer *ifail);
  extern NAG_DLL_EXPIMP double NAG_CALL g01fec(double p, double a, double b, double tol, NagError *fail);
  extern double g01fef_f(double p, double a, double b, double tol,
                         Integer *ifail);
  extern NAG_DLL_EXPIMP double NAG_CALL g01ffc(double p, double a, double b, double tol, NagError *fail);
  extern double g01fff_f(double p, double a, double b, double tol,
                         Integer *ifail);
  extern NAG_DLL_EXPIMP double NAG_CALL g01fmc(double p, double v, Integer ir, NagError *fail);

  extern double g01fmf_f(double p, double v, Integer ir, Integer *ifail);
  extern double g01fmf_c(double p, double v, Integer ir, Integer *ifail);
  extern void g01fmz_f(double p, double v, Integer ir, double *ql,
                       double *qu, double *pl, double *pu, Integer *ierr);
  extern void g01fmz_c(double p, double v, Integer ir, double *ql,
                       double *qu, double *pl, double *pu, Integer *ierr);
  extern NAG_DLL_EXPIMP double NAG_CALL g01ftc(double x, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01gbc(double t, double df, double delta, double tol,
                       Integer max_iter, NagError *fail);
  extern double g01gbf_f(double t, double df, double delta, double tol,
                         Integer maxit, Integer *ifail);
  extern double g01gbz_f(double z);
  extern NAG_DLL_EXPIMP double NAG_CALL g01gcc(double x, double df, double lambda, double tol,
                       Integer max_iter, NagError *fail);
  extern double g01gcf_f(double x, double df, double rlamda, double tol,
                         Integer maxit, Integer *ifail);
  extern NAG_DLL_EXPIMP double NAG_CALL g01gdc(double f, double df1, double df2, double lambda,
                       double tol, Integer max_iter, NagError *fail);
  extern double g01gdf_f(double f, double df1, double df2, double rlamda,
                         double tol, Integer maxit, Integer *ifail);
  extern NAG_DLL_EXPIMP double NAG_CALL g01gec(double x, double a, double b, double lambda,
                       double tol, Integer max_iter, NagError *fail);
  extern double g01gef_f(double x, double a, double b, double rlamda,
                         double tol, Integer maxit, Integer *ifail);
  extern NAG_DLL_EXPIMP double NAG_CALL g01hac(double x, double y, double rho, NagError *fail);
  extern double g01haf_f(double x, double y, double rho, Integer *ifail);
  extern NAG_DLL_EXPIMP double NAG_CALL g01hbc(Nag_TailProbability tail, Integer n, const double a[], const double b[],
                       const double mean[], const double sigma[], Integer tdsig, double tol,
                       Integer maxpts,  NagError *fail);
  extern double g01hbf_c(const char *tail, Integer n, const double a[], const double b[],
                         const double xmu[], const double sig[], Integer ldsig, double tol,
                         double wk[], Integer lwk, Integer *ifail, Integer tail_len, Nag_ag01hb *ag01hb_1);
  extern double g01hbf_f(const char *tail, Integer n, const double a[], const double b[],
                         const double xmu[], const double sig[], Integer ldsig, double tol,
                         double wk[], Integer lwk, Integer *ifail, Integer tail_len);
  extern double g01hby_f(Integer n, double z[]);
  extern double g01hby_c(Integer n, double z[], Nag_User *comm);
  extern double g01hbz_c(double x, Nag_User *comm);
  extern double g01hbz_f(double x);
  extern double g01maz_f(double x);
  extern NAG_DLL_EXPIMP double NAG_CALL g01mtc(double x);
  extern NAG_DLL_EXPIMP double NAG_CALL g01muc(double x, const double comm_arr[]);
  extern NAG_DLL_EXPIMP void NAG_CALL g01jcc(const double a[], const Integer mult[], const double rlamda[], Integer n, double c, double *p, double *pdf, double tol, Integer maxit, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g01jdc(Nag_LCCMethod method, Integer n, const double rlam[], double d, double c, double *prob, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01mbc(double x);

  extern NAG_DLL_EXPIMP void NAG_CALL g01nac(Nag_OrderType order, Nag_SelectMoments mom, Nag_IncludeMean mean, Integer n, const double a[], Integer pda, const double emu[], const double sigma[], Integer pdsig, Integer l, double rkum[], double rmom[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g01nbc(Nag_OrderType order, Nag_MomentType ratio_type, Nag_IncludeMean mean, Integer n, const double a[], Integer pda, const double b[], Integer pdb, const double c[], Integer pdc, const double ela[], const double emu[], const double sigma[], Integer pdsig, Integer l1, Integer l2, Integer *lmax, double rmom[], double *abserr, double eps, NagError *fail);

  extern NAG_DLL_EXPIMP double NAG_CALL g01ptc(double x); 

  extern NAG_DLL_EXPIMP double NAG_CALL g01qtc(double x); 

  extern NAG_DLL_EXPIMP double NAG_CALL g01rtc(double x); 

  extern NAG_DLL_EXPIMP void NAG_CALL g01zuc(double rkappa, double beta2, Integer mode, double *xl, double *xu, double work[], NagError *fail); 
  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGG01 */
